/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard.text;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.scoreboards.display.formatters.DisplayFormatter;
import net.impactdev.impactor.api.scoreboards.display.text.ComponentElement;
import net.impactdev.impactor.api.scoreboards.display.text.ScoreboardComponent;
import net.kyori.adventure.text.Component;

public final class ImpactorScoreboardComponent
implements ScoreboardComponent {
    private final List<ComponentElement> elements;

    private ImpactorScoreboardComponent(ComponentElement root) {
        this.elements = ImmutableList.of((Object)root);
    }

    private ImpactorScoreboardComponent(List<ComponentElement> elements, ComponentElement child) {
        this.elements = ImmutableList.builder().addAll(elements).add((Object)child).build();
    }

    @Override
    public Component resolve(PlatformSource viewer) {
        return this.elements.stream().map(element -> Optional.ofNullable(element.formatter()).map(formatter -> {
            Component result = formatter.format(element.provider().parse(viewer));
            if (formatter instanceof DisplayFormatter.Stateful) {
                DisplayFormatter.Stateful stateful = (DisplayFormatter.Stateful)formatter;
                stateful.step();
            }
            return result;
        }).orElse(element.provider().parse(viewer))).reduce(Component::append).orElse((Component)Component.empty());
    }

    @Override
    public ScoreboardComponent append(ComponentElement element) {
        return new ImpactorScoreboardComponent(this.elements, element);
    }

    @Override
    public List<ComponentElement> elements() {
        return this.elements;
    }

    public static final class ScoreboardComponentFactory
    implements ScoreboardComponent.Factory {
        @Override
        public ScoreboardComponent create(ComponentElement root) {
            return new ImpactorScoreboardComponent(root);
        }
    }
}

